<?php
// ============================================================
//  public/subscribe.php — Newsletter subscription handler
//  Accepts POST from any newsletter form on the site.
// ============================================================
require_once dirname(__DIR__) . '/app/config.php';
require_once ROOT_PATH . '/app/db.php';
require_once ROOT_PATH . '/app/functions.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    redirect(SITE_URL);
}

if (!csrf_verify()) {
    redirect_with_message(
        $_SERVER['HTTP_REFERER'] ?? SITE_URL,
        'Invalid form submission. Please try again.',
        'error'
    );
}

$email  = trim($_POST['email']  ?? '');
$name   = trim($_POST['name']   ?? '');
$source = trim($_POST['source'] ?? 'website');

$allowedSources = ['footer','homepage','articles-sidebar','article-sidebar','video-sidebar','resources'];
$source = in_array($source, $allowedSources, true) ? $source : 'website';

if (!filter_var($email, FILTER_VALIDATE_EMAIL) || strlen($email) > 150) {
    redirect_with_message(
        $_SERVER['HTTP_REFERER'] ?? SITE_URL,
        'Please enter a valid email address.',
        'error'
    );
}

$existing = db_one("SELECT id, status FROM subscribers WHERE email = ?", [strtolower($email)]);

if ($existing) {
    if ($existing['status'] === 'active') {
        redirect_with_message($_SERVER['HTTP_REFERER'] ?? SITE_URL, "You're already subscribed. Thank you!", 'success');
    }
    // Re-activate unsubscribed user
    db_run("UPDATE subscribers SET status='active', source=?, subscribed_at=NOW(), unsubscribed_at=NULL WHERE id=?",
           [$source, $existing['id']]);
    redirect_with_message($_SERVER['HTTP_REFERER'] ?? SITE_URL, "Welcome back! You've been re-subscribed.", 'success');
}

db_insert(
    "INSERT INTO subscribers (email, name, status, source) VALUES (?, ?, 'active', ?)",
    [strtolower($email), $name ?: null, $source]
);

// Optional welcome email — uncomment once SMTP is configured:
/*
mail(
    $email,
    'Welcome to GetPhDReady!',
    "Hi " . ($name ?: 'there') . ",\n\nYou're subscribed to the weekly digest.\n\n" . SITE_URL,
    "From: " . SITE_NAME . " <" . SITE_EMAIL . ">\r\nContent-Type: text/plain; charset=UTF-8\r\n"
);
*/

redirect_with_message(
    $_SERVER['HTTP_REFERER'] ?? SITE_URL,
    "You're subscribed! Welcome to the GetPhDReady community.",
    'success'
);
