<?php
// ============================================================
//  admin/videos/index.php — Video list
// ============================================================
require_once dirname(__DIR__, 2) . '/app/config.php';
require_once ROOT_PATH . '/app/db.php';
require_once ROOT_PATH . '/app/functions.php';
require_editor();

if (isset($_GET['delete']) && has_role('admin')) {
    db_run("DELETE FROM videos WHERE id = ?", [(int)$_GET['delete']]);
    redirect_with_message(SITE_URL . '/admin/videos/index.php', 'Video deleted.', 'success');
}
if (isset($_GET['publish'])) {
    db_run("UPDATE videos SET status='published', published_at=COALESCE(published_at,NOW()) WHERE id=?", [(int)$_GET['publish']]);
    redirect_with_message(SITE_URL . '/admin/videos/index.php', 'Video published.', 'success');
}
if (isset($_GET['draft'])) {
    db_run("UPDATE videos SET status='draft' WHERE id=?", [(int)$_GET['draft']]);
    redirect_with_message(SITE_URL . '/admin/videos/index.php', 'Video moved to draft.', 'success');
}

$search      = trim($_GET['q'] ?? '');
$currentPage = max(1, (int)($_GET['page'] ?? 1));
$params      = [];
$where       = ['1=1'];
if ($search) { $where[] = 'v.title LIKE ?'; $params[] = '%'.$search.'%'; }
$whereSQL = implode(' AND ', $where);

$total  = db_count("SELECT COUNT(*) FROM videos v WHERE $whereSQL", $params);
$pager  = paginate($total, $currentPage, ADMIN_ROWS_PER_PAGE);
$videos = db_all("
    SELECT v.*, c.name AS category_name
    FROM   videos v
    LEFT JOIN categories c ON c.id = v.category_id
    WHERE  $whereSQL
    ORDER  BY v.created_at DESC
    LIMIT ? OFFSET ?
", array_merge($params, [$pager['per_page'], $pager['offset']]));

$adminTitle = 'Videos';
$ADMIN_TPL  = ROOT_PATH . '/admin/templates';
include $ADMIN_TPL . '/admin_header.php';
?>

<div class="admin-toolbar">
  <form class="toolbar-filters" method="GET">
    <input type="search" name="q" value="<?= h($search) ?>" placeholder="Search videos…" class="admin-search">
    <button type="submit" class="admin-btn">Search</button>
    <?php if ($search): ?><a href="?" class="admin-btn admin-btn--ghost">Clear</a><?php endif; ?>
  </form>
  <a href="<?= SITE_URL ?>/admin/videos/create.php" class="admin-btn admin-btn--primary">+ New Video</a>
</div>

<div class="admin-card" style="padding:0;">
  <table class="admin-table">
    <thead>
      <tr><th>Thumb</th><th>Title</th><th>Type</th><th>Duration</th><th>Status</th><th>Views</th><th>Actions</th></tr>
    </thead>
    <tbody>
      <?php if (empty($videos)): ?>
        <tr><td colspan="7" class="td-empty">No videos found.</td></tr>
      <?php endif; ?>
      <?php foreach ($videos as $v):
        $thumb = $v['thumbnail'] ? UPLOAD_URL.'/'.$v['thumbnail'] : youtube_thumb_url($v['youtube_id']);
      ?>
      <tr>
        <td><img src="<?= h($thumb) ?>" alt="" style="width:80px;height:45px;object-fit:cover;border-radius:2px;"></td>
        <td class="td-title">
          <a href="<?= SITE_URL ?>/admin/videos/edit.php?id=<?= $v['id'] ?>"><?= h($v['title']) ?></a>
          <small style="color:var(--text-secondary);"><?= h($v['category_name'] ?? '') ?></small>
        </td>
        <td><?= h(ucfirst(str_replace('_',' ',$v['video_type']))) ?></td>
        <td><?= format_duration($v['duration_seconds']) ?></td>
        <td><span class="status-badge status-<?= $v['status'] ?>"><?= ucfirst($v['status']) ?></span></td>
        <td><?= number_format($v['views']) ?></td>
        <td class="td-actions">
          <a href="<?= SITE_URL ?>/admin/videos/edit.php?id=<?= $v['id'] ?>" class="tbl-btn">Edit</a>
          <a href="<?= SITE_URL ?>/video.php?slug=<?= h($v['slug']) ?>" target="_blank" class="tbl-btn">View</a>
          <?php if ($v['status']==='draft'): ?>
            <a href="?publish=<?= $v['id'] ?>" class="tbl-btn tbl-btn--success">Publish</a>
          <?php else: ?>
            <a href="?draft=<?= $v['id'] ?>"   class="tbl-btn tbl-btn--warning">Unpublish</a>
          <?php endif; ?>
          <?php if (has_role('admin')): ?>
            <a href="?delete=<?= $v['id'] ?>" class="tbl-btn tbl-btn--danger"
               onclick="return confirm('Delete this video?')">Delete</a>
          <?php endif; ?>
        </td>
      </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>

<?php
$baseUrl = SITE_URL . '/admin/videos/index.php' . ($search ? '?q='.urlencode($search) : '');
include TEMPLATE_PATH . '/pagination.php';
include $ADMIN_TPL . '/admin_footer.php';
?>
