<?php
// ============================================================
//  admin/templates/admin_header.php
//  Variables expected: $adminTitle (string)
// ============================================================
$adminTitle = $adminTitle ?? 'Admin';
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title><?= h($adminTitle) ?> — <?= SITE_NAME ?> Admin</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link href="https://fonts.googleapis.com/css2?family=Cormorant+Garamond:ital,wght@0,300;0,600;1,300&family=DM+Sans:opsz,wght@9..40,300;9..40,400;9..40,500&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="<?= SITE_URL ?>/assets/css/admin.css">
</head>
<body class="admin-body">

<div class="admin-layout">

  <!-- ── SIDEBAR ── -->
  <aside class="admin-sidebar">
    <div class="admin-sidebar-top">
      <a href="<?= SITE_URL ?>/admin/index.php" class="admin-logo">
        Get<span>PhD</span>Ready
        <small>Admin</small>
      </a>
    </div>

    <nav class="admin-nav">
      <div class="admin-nav-group">
        <span class="nav-group-label">Content</span>
        <a href="<?= SITE_URL ?>/admin/index.php"
           class="admin-nav-link <?= str_contains($_SERVER['PHP_SELF'], '/admin/index') ? 'active' : '' ?>">
          <span class="nav-icon">⊞</span> Dashboard
        </a>
        <a href="<?= SITE_URL ?>/admin/articles/index.php"
           class="admin-nav-link <?= str_contains($_SERVER['PHP_SELF'], '/admin/articles') ? 'active' : '' ?>">
          <span class="nav-icon">✍</span> Articles
        </a>
        <a href="<?= SITE_URL ?>/admin/videos/index.php"
           class="admin-nav-link <?= str_contains($_SERVER['PHP_SELF'], '/admin/videos') ? 'active' : '' ?>">
          <span class="nav-icon">▶</span> Videos
        </a>
        <a href="<?= SITE_URL ?>/admin/resources/index.php"
           class="admin-nav-link <?= str_contains($_SERVER['PHP_SELF'], '/admin/resources') ? 'active' : '' ?>">
          <span class="nav-icon">📦</span> Resources
        </a>
      </div>

      <div class="admin-nav-group">
        <span class="nav-group-label">Community</span>
        <a href="<?= SITE_URL ?>/admin/comments/index.php"
           class="admin-nav-link <?= str_contains($_SERVER['PHP_SELF'], '/admin/comments') ? 'active' : '' ?>">
          <span class="nav-icon">💬</span> Comments
          <?php
          $pendingComments = db_count("SELECT COUNT(*) FROM comments WHERE status = 'pending'");
          if ($pendingComments > 0): ?>
            <span class="nav-badge"><?= $pendingComments ?></span>
          <?php endif; ?>
        </a>
        <a href="<?= SITE_URL ?>/admin/subscribers/index.php"
           class="admin-nav-link <?= str_contains($_SERVER['PHP_SELF'], '/admin/subscribers') ? 'active' : '' ?>">
          <span class="nav-icon">✉</span> Subscribers
        </a>
        <a href="<?= SITE_URL ?>/admin/messages/index.php"
           class="admin-nav-link <?= str_contains($_SERVER['PHP_SELF'], '/admin/messages') ? 'active' : '' ?>">
          <span class="nav-icon">📬</span> Messages
          <?php
          $unreadMessages = db_count("SELECT COUNT(*) FROM contact_messages WHERE is_read = 0");
          if ($unreadMessages > 0): ?>
            <span class="nav-badge"><?= $unreadMessages ?></span>
          <?php endif; ?>
        </a>
      </div>

      <?php if (has_role('admin')): ?>
      <div class="admin-nav-group">
        <span class="nav-group-label">Settings</span>
        <a href="<?= SITE_URL ?>/admin/users/index.php"
           class="admin-nav-link <?= str_contains($_SERVER['PHP_SELF'], '/admin/users') ? 'active' : '' ?>">
          <span class="nav-icon">👤</span> Users
        </a>
      </div>
      <?php endif; ?>
    </nav>

    <div class="admin-sidebar-footer">
      <span><?= h($_SESSION['user_name']) ?></span>
      <a href="<?= SITE_URL ?>/admin/logout.php" class="logout-link">Sign out</a>
    </div>
  </aside>

  <!-- ── MAIN CONTENT ── -->
  <main class="admin-main">
    <!-- Top bar -->
    <div class="admin-topbar">
      <h1 class="admin-page-title"><?= h($adminTitle) ?></h1>
      <div class="topbar-right">
        <a href="<?= SITE_URL ?>" target="_blank" class="view-site-btn">↗ View site</a>
      </div>
    </div>

    <!-- Flash message -->
    <?php flash_html(); ?>

    <!-- Page content starts here -->
