<?php
// ============================================================
//  admin/subscribers/index.php — Subscriber list + CSV export
// ============================================================
require_once dirname(__DIR__, 2) . '/app/config.php';
require_once ROOT_PATH . '/app/db.php';
require_once ROOT_PATH . '/app/functions.php';
require_admin();

// CSV export
if (isset($_GET['export'])) {
    $all = db_all("SELECT email, name, source, subscribed_at FROM subscribers WHERE status='active' ORDER BY subscribed_at DESC");
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename="subscribers_' . date('Y-m-d') . '.csv"');
    $out = fopen('php://output', 'w');
    fputcsv($out, ['Email', 'Name', 'Source', 'Subscribed At']);
    foreach ($all as $s) fputcsv($out, [$s['email'], $s['name'], $s['source'], $s['subscribed_at']]);
    fclose($out);
    exit;
}

// Unsubscribe action
if (isset($_GET['unsub'])) {
    db_run("UPDATE subscribers SET status='unsubscribed', unsubscribed_at=NOW() WHERE id=?", [(int)$_GET['unsub']]);
    redirect_with_message(SITE_URL.'/admin/subscribers/index.php', 'Subscriber removed.', 'success');
}

$search      = trim($_GET['q'] ?? '');
$currentPage = max(1, (int)($_GET['page'] ?? 1));
$params      = ["'active'"];
$where       = ["status = 'active'"];
if ($search) { $where[] = '(email LIKE ? OR name LIKE ?)'; $params[] = '%'.$search.'%'; $params[] = '%'.$search.'%'; }
$whereSQL = implode(' AND ', $where);

$total = db_count("SELECT COUNT(*) FROM subscribers WHERE $whereSQL",
                  $search ? ['%'.$search.'%','%'.$search.'%'] : []);
$pager = paginate($total, $currentPage, ADMIN_ROWS_PER_PAGE);
$subs  = db_all("SELECT * FROM subscribers WHERE $whereSQL ORDER BY subscribed_at DESC LIMIT ? OFFSET ?",
                array_merge($search ? ['%'.$search.'%','%'.$search.'%'] : [], [$pager['per_page'], $pager['offset']]));

$adminTitle = 'Subscribers';
$ADMIN_TPL  = ROOT_PATH . '/admin/templates';
include $ADMIN_TPL . '/admin_header.php';
?>

<div class="admin-toolbar">
  <form class="toolbar-filters" method="GET">
    <input type="search" name="q" value="<?= h($search) ?>" placeholder="Search by email or name…" class="admin-search">
    <button type="submit" class="admin-btn">Search</button>
    <?php if ($search): ?><a href="?" class="admin-btn admin-btn--ghost">Clear</a><?php endif; ?>
  </form>
  <div style="display:flex;gap:.5rem;">
    <span class="stat-chip" style="padding:.5rem 1rem;background:var(--mist);border-radius:2px;font-size:.82rem;">
      <strong><?= number_format($total) ?></strong> active subscribers
    </span>
    <a href="?export=1" class="admin-btn admin-btn--primary">↓ Export CSV</a>
  </div>
</div>

<div class="admin-card" style="padding:0;">
  <table class="admin-table">
    <thead>
      <tr><th>Email</th><th>Name</th><th>Source</th><th>Subscribed</th><th>Actions</th></tr>
    </thead>
    <tbody>
      <?php if (empty($subs)): ?>
        <tr><td colspan="5" class="td-empty">No subscribers found.</td></tr>
      <?php endif; ?>
      <?php foreach ($subs as $s): ?>
      <tr>
        <td><?= h($s['email']) ?></td>
        <td><?= h($s['name'] ?? '—') ?></td>
        <td><span class="source-tag"><?= h($s['source']) ?></span></td>
        <td><?= format_date($s['subscribed_at'], 'd M Y') ?></td>
        <td class="td-actions">
          <a href="?unsub=<?= $s['id'] ?><?= $search?'&q='.urlencode($search):'' ?>"
             class="tbl-btn tbl-btn--danger"
             onclick="return confirm('Remove this subscriber?')">Remove</a>
        </td>
      </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>

<?php
$baseUrl = SITE_URL . '/admin/subscribers/index.php' . ($search ? '?q='.urlencode($search) : '');
include TEMPLATE_PATH . '/pagination.php';
include $ADMIN_TPL . '/admin_footer.php';
?>
