<?php
// ============================================================
//  admin/messages/index.php — Contact messages inbox
// ============================================================
require_once dirname(__DIR__, 2) . '/app/config.php';
require_once ROOT_PATH . '/app/db.php';
require_once ROOT_PATH . '/app/functions.php';
require_admin();

if (isset($_GET['delete'])) {
    db_run("DELETE FROM contact_messages WHERE id=?", [(int)$_GET['delete']]);
    redirect_with_message(SITE_URL.'/admin/messages/index.php', 'Message deleted.', 'success');
}

// View single message (mark as read)
$viewing = null;
if (isset($_GET['view'])) {
    $mid = (int)$_GET['view'];
    db_run("UPDATE contact_messages SET is_read=1 WHERE id=?", [$mid]);
    $viewing = db_one("SELECT * FROM contact_messages WHERE id=?", [$mid]);
}

$currentPage = max(1, (int)($_GET['page'] ?? 1));
$total    = db_count("SELECT COUNT(*) FROM contact_messages");
$pager    = paginate($total, $currentPage, ADMIN_ROWS_PER_PAGE);
$messages = db_all("SELECT * FROM contact_messages ORDER BY created_at DESC LIMIT ? OFFSET ?",
                   [$pager['per_page'], $pager['offset']]);

$adminTitle = 'Contact Messages';
$ADMIN_TPL  = ROOT_PATH . '/admin/templates';
include $ADMIN_TPL . '/admin_header.php';
?>

<?php if ($viewing): ?>
<!-- Single message view -->
<div class="admin-card" style="max-width:680px;">
  <div class="admin-card-header">
    <h2>Message from <?= h($viewing['name']) ?></h2>
    <a href="<?= SITE_URL ?>/admin/messages/index.php">← Back to inbox</a>
  </div>
  <table class="meta-table">
    <tr><th>From</th>    <td><?= h($viewing['name']) ?></td></tr>
    <tr><th>Email</th>   <td><a href="mailto:<?= h($viewing['email']) ?>"><?= h($viewing['email']) ?></a></td></tr>
    <tr><th>Audience</th><td><?= h($viewing['audience_type'] ?: '—') ?></td></tr>
    <tr><th>Received</th><td><?= format_date($viewing['created_at'], 'd M Y H:i') ?></td></tr>
  </table>
  <div class="message-body"><?= nl2br(h($viewing['message'])) ?></div>
  <div style="margin-top:1.5rem;display:flex;gap:.75rem;">
    <a href="mailto:<?= h($viewing['email']) ?>?subject=Re: Your message to GetPhDReady"
       class="admin-btn admin-btn--primary">Reply via Email</a>
    <a href="?delete=<?= $viewing['id'] ?>"
       class="admin-btn tbl-btn--danger"
       onclick="return confirm('Delete this message?')">Delete</a>
  </div>
</div>

<?php else: ?>
<!-- Inbox list -->
<div class="admin-card" style="padding:0;">
  <table class="admin-table">
    <thead>
      <tr><th></th><th>Name</th><th>Email</th><th>Audience</th><th>Preview</th><th>Date</th><th>Actions</th></tr>
    </thead>
    <tbody>
      <?php if (empty($messages)): ?>
        <tr><td colspan="7" class="td-empty">No messages yet.</td></tr>
      <?php endif; ?>
      <?php foreach ($messages as $m): ?>
      <tr class="<?= !$m['is_read'] ? 'row-unread' : '' ?>">
        <td><?= !$m['is_read'] ? '<span class="unread-dot"></span>' : '' ?></td>
        <td><strong><?= h($m['name']) ?></strong></td>
        <td><?= h($m['email']) ?></td>
        <td><?= h($m['audience_type'] ?: '—') ?></td>
        <td><?= h(truncate($m['message'], 70)) ?></td>
        <td><?= format_date($m['created_at'], 'd M Y') ?></td>
        <td class="td-actions">
          <a href="?view=<?= $m['id'] ?>" class="tbl-btn">Read</a>
          <a href="mailto:<?= h($m['email']) ?>" class="tbl-btn">Reply</a>
          <a href="?delete=<?= $m['id'] ?>" class="tbl-btn tbl-btn--danger"
             onclick="return confirm('Delete?')">Delete</a>
        </td>
      </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>

<?php
$baseUrl = SITE_URL . '/admin/messages/index.php';
include TEMPLATE_PATH . '/pagination.php';
?>
<?php endif; ?>

<?php include $ADMIN_TPL . '/admin_footer.php'; ?>
