<?php
// ============================================================
//  admin/login.php
// ============================================================
require_once dirname(__DIR__) . '/app/config.php';
require_once ROOT_PATH . '/app/db.php';
require_once ROOT_PATH . '/app/functions.php';

// Already logged in → go to dashboard
if (is_logged_in()) redirect(SITE_URL . '/admin/index.php');

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!csrf_verify()) {
        $error = 'Invalid request. Please try again.';
    } else {
        $email    = trim($_POST['email']    ?? '');
        $password = trim($_POST['password'] ?? '');

        $user = db_one(
            "SELECT * FROM users WHERE email = ? AND is_active = 1 AND role IN ('admin','editor')",
            [$email]
        );

        if ($user && password_verify($password, $user['password'])) {
            // Regenerate session ID on login to prevent session fixation
            session_regenerate_id(true);
            $_SESSION['user_id']   = $user['id'];
            $_SESSION['user_name'] = $user['name'];
            $_SESSION['user_role'] = $user['role'];
            redirect(SITE_URL . '/admin/index.php');
        } else {
            // Intentionally vague error message
            $error = 'Invalid email or password.';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Admin Login — <?= SITE_NAME ?></title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link href="https://fonts.googleapis.com/css2?family=Cormorant+Garamond:ital,wght@0,300;0,600;1,300&family=DM+Sans:opsz,wght@9..40,300;9..40,400;9..40,500&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="<?= SITE_URL ?>/assets/css/admin.css">
</head>
<body class="login-body">

<div class="login-wrap">
  <div class="login-card">
    <a href="<?= SITE_URL ?>" class="login-logo">Get<span>PhD</span>Ready</a>
    <h1>Admin Login</h1>

    <?php if ($error): ?>
      <div class="alert alert--error"><?= h($error) ?></div>
    <?php endif; ?>

    <form method="POST" action="<?= SITE_URL ?>/admin/login.php">
      <?= csrf_field() ?>
      <div class="form-field">
        <label for="email">Email</label>
        <input type="email" id="email" name="email"
               value="<?= h($_POST['email'] ?? '') ?>"
               required autofocus>
      </div>
      <div class="form-field">
        <label for="password">Password</label>
        <input type="password" id="password" name="password" required>
      </div>
      <button type="submit" class="btn-primary" style="width:100%;margin-top:.5rem;">
        Sign In
      </button>
    </form>
    <p style="margin-top:1.5rem;text-align:center;">
      <a href="<?= SITE_URL ?>" style="font-size:.82rem;color:var(--text-secondary);">← Back to site</a>
    </p>
  </div>
</div>
</body>
</html>
