<?php
// ============================================================
//  admin/index.php — Dashboard
// ============================================================
require_once dirname(__DIR__) . '/app/config.php';
require_once ROOT_PATH . '/app/db.php';
require_once ROOT_PATH . '/app/functions.php';
require_admin();

// ── Stats ─────────────────────────────────────────────────────
$stats = [
    'articles'    => db_count("SELECT COUNT(*) FROM articles   WHERE status='published'"),
    'drafts'      => db_count("SELECT COUNT(*) FROM articles   WHERE status='draft'"),
    'videos'      => db_count("SELECT COUNT(*) FROM videos     WHERE status='published'"),
    'resources'   => db_count("SELECT COUNT(*) FROM resources  WHERE status='published'"),
    'subscribers' => db_count("SELECT COUNT(*) FROM subscribers WHERE status='active'"),
    'comments'    => db_count("SELECT COUNT(*) FROM comments   WHERE status='pending'"),
    'messages'    => db_count("SELECT COUNT(*) FROM contact_messages WHERE is_read=0"),
    'total_views' => db_count("SELECT COALESCE(SUM(views),0) FROM articles"),
];

// ── Recent articles ───────────────────────────────────────────
$recentArticles = db_all("
    SELECT a.id, a.title, a.slug, a.status, a.views, a.published_at, a.created_at,
           u.name AS author_name, c.name AS category_name
    FROM   articles a
    JOIN   users u      ON u.id = a.author_id
    LEFT JOIN categories c ON c.id = a.category_id
    ORDER  BY a.created_at DESC
    LIMIT  8
");

// ── Recent subscribers ────────────────────────────────────────
$recentSubs = db_all("
    SELECT email, name, source, subscribed_at
    FROM   subscribers
    WHERE  status = 'active'
    ORDER  BY subscribed_at DESC
    LIMIT  6
");

// ── Pending comments ──────────────────────────────────────────
$pendingComments = db_all("
    SELECT c.id, c.body, c.created_at, c.guest_name,
           a.title AS article_title, a.slug AS article_slug
    FROM   comments c
    JOIN   articles a ON a.id = c.article_id
    WHERE  c.status = 'pending'
    ORDER  BY c.created_at DESC
    LIMIT  5
");

$adminTitle = 'Dashboard';
$ADMIN_TPL  = ROOT_PATH . '/admin/templates';
include $ADMIN_TPL . '/admin_header.php';
?>

<!-- ── STAT CARDS ── -->
<div class="stat-cards">
  <div class="stat-card">
    <div class="stat-icon">✍</div>
    <div class="stat-body">
      <div class="stat-num"><?= $stats['articles'] ?></div>
      <div class="stat-label">Published Articles</div>
    </div>
    <a href="<?= SITE_URL ?>/admin/articles/index.php" class="stat-link">View →</a>
  </div>
  <div class="stat-card">
    <div class="stat-icon">▶</div>
    <div class="stat-body">
      <div class="stat-num"><?= $stats['videos'] ?></div>
      <div class="stat-label">Published Videos</div>
    </div>
    <a href="<?= SITE_URL ?>/admin/videos/index.php" class="stat-link">View →</a>
  </div>
  <div class="stat-card">
    <div class="stat-icon">✉</div>
    <div class="stat-body">
      <div class="stat-num"><?= number_format($stats['subscribers']) ?></div>
      <div class="stat-label">Active Subscribers</div>
    </div>
    <a href="<?= SITE_URL ?>/admin/subscribers/index.php" class="stat-link">View →</a>
  </div>
  <div class="stat-card">
    <div class="stat-icon">👁</div>
    <div class="stat-body">
      <div class="stat-num"><?= number_format($stats['total_views']) ?></div>
      <div class="stat-label">Total Article Views</div>
    </div>
  </div>
  <?php if ($stats['comments'] > 0): ?>
  <div class="stat-card stat-card--alert">
    <div class="stat-icon">💬</div>
    <div class="stat-body">
      <div class="stat-num"><?= $stats['comments'] ?></div>
      <div class="stat-label">Pending Comments</div>
    </div>
    <a href="<?= SITE_URL ?>/admin/comments/index.php" class="stat-link">Review →</a>
  </div>
  <?php endif; ?>
  <?php if ($stats['messages'] > 0): ?>
  <div class="stat-card stat-card--alert">
    <div class="stat-icon">📬</div>
    <div class="stat-body">
      <div class="stat-num"><?= $stats['messages'] ?></div>
      <div class="stat-label">Unread Messages</div>
    </div>
    <a href="<?= SITE_URL ?>/admin/messages/index.php" class="stat-link">Read →</a>
  </div>
  <?php endif; ?>
</div>

<!-- ── QUICK ACTIONS ── -->
<div class="quick-actions">
  <a href="<?= SITE_URL ?>/admin/articles/create.php" class="quick-btn quick-btn--primary">+ New Article</a>
  <a href="<?= SITE_URL ?>/admin/videos/create.php"   class="quick-btn">+ New Video</a>
  <a href="<?= SITE_URL ?>/admin/resources/create.php" class="quick-btn">+ New Resource</a>
</div>

<!-- ── DASHBOARD GRID ── -->
<div class="dashboard-grid">

  <!-- Recent Articles -->
  <div class="admin-card">
    <div class="admin-card-header">
      <h2>Recent Articles</h2>
      <a href="<?= SITE_URL ?>/admin/articles/index.php">View all</a>
    </div>
    <table class="admin-table">
      <thead>
        <tr><th>Title</th><th>Category</th><th>Status</th><th>Views</th><th>Date</th><th></th></tr>
      </thead>
      <tbody>
        <?php foreach ($recentArticles as $a): ?>
        <tr>
          <td class="td-title">
            <a href="<?= SITE_URL ?>/admin/articles/edit.php?id=<?= $a['id'] ?>"><?= h($a['title']) ?></a>
          </td>
          <td><?= h($a['category_name'] ?? '—') ?></td>
          <td><span class="status-badge status-<?= $a['status'] ?>"><?= ucfirst($a['status']) ?></span></td>
          <td><?= number_format($a['views']) ?></td>
          <td><?= format_date($a['created_at'], 'd M Y') ?></td>
          <td class="td-actions">
            <a href="<?= SITE_URL ?>/admin/articles/edit.php?id=<?= $a['id'] ?>" class="tbl-btn">Edit</a>
            <a href="<?= SITE_URL ?>/article.php?slug=<?= h($a['slug']) ?>" target="_blank" class="tbl-btn">View</a>
          </td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>

  <!-- Right column -->
  <div class="dashboard-right">

    <!-- Pending comments -->
    <?php if ($pendingComments): ?>
    <div class="admin-card">
      <div class="admin-card-header">
        <h2>Pending Comments</h2>
        <a href="<?= SITE_URL ?>/admin/comments/index.php">View all</a>
      </div>
      <?php foreach ($pendingComments as $c): ?>
      <div class="pending-comment">
        <div class="pc-meta">
          <strong><?= h($c['guest_name']) ?></strong>
          on <a href="<?= SITE_URL ?>/article.php?slug=<?= h($c['article_slug']) ?>" target="_blank"><?= h(truncate($c['article_title'], 40)) ?></a>
          <span class="pc-time"><?= time_ago($c['created_at']) ?></span>
        </div>
        <p class="pc-body"><?= h(truncate($c['body'], 120)) ?></p>
        <div class="pc-actions">
          <a href="<?= SITE_URL ?>/admin/comments/index.php?approve=<?= $c['id'] ?>" class="tbl-btn tbl-btn--success">Approve</a>
          <a href="<?= SITE_URL ?>/admin/comments/index.php?spam=<?= $c['id'] ?>"    class="tbl-btn tbl-btn--danger">Spam</a>
        </div>
      </div>
      <?php endforeach; ?>
    </div>
    <?php endif; ?>

    <!-- Recent subscribers -->
    <div class="admin-card">
      <div class="admin-card-header">
        <h2>New Subscribers</h2>
        <a href="<?= SITE_URL ?>/admin/subscribers/index.php">View all</a>
      </div>
      <ul class="sub-list">
        <?php foreach ($recentSubs as $s): ?>
        <li>
          <span class="sub-email"><?= h($s['email']) ?></span>
          <span class="sub-meta"><?= h($s['source']) ?> · <?= time_ago($s['subscribed_at']) ?></span>
        </li>
        <?php endforeach; ?>
      </ul>
    </div>

  </div>
</div>

<?php include $ADMIN_TPL . '/admin_footer.php'; ?>
