<?php
// ============================================================
//  admin/comments/index.php — Comments moderation
// ============================================================
require_once dirname(__DIR__, 2) . '/app/config.php';
require_once ROOT_PATH . '/app/db.php';
require_once ROOT_PATH . '/app/functions.php';
require_editor();

// Quick actions via GET (CSRF not required for idempotent status changes)
if (isset($_GET['approve'])) {
    db_run("UPDATE comments SET status='approved' WHERE id=?", [(int)$_GET['approve']]);
    redirect_with_message(SITE_URL.'/admin/comments/index.php', 'Comment approved.', 'success');
}
if (isset($_GET['spam'])) {
    db_run("UPDATE comments SET status='spam' WHERE id=?", [(int)$_GET['spam']]);
    redirect_with_message(SITE_URL.'/admin/comments/index.php', 'Comment marked as spam.', 'success');
}
if (isset($_GET['delete']) && has_role('admin')) {
    db_run("DELETE FROM comments WHERE id=?", [(int)$_GET['delete']]);
    redirect_with_message(SITE_URL.'/admin/comments/index.php', 'Comment deleted.', 'success');
}

$filterStatus = $_GET['status'] ?? 'pending';
$currentPage  = max(1, (int)($_GET['page'] ?? 1));
$params       = [];
$where        = ['1=1'];
if ($filterStatus) { $where[] = 'c.status = ?'; $params[] = $filterStatus; }
$whereSQL = implode(' AND ', $where);

$total    = db_count("SELECT COUNT(*) FROM comments c WHERE $whereSQL", $params);
$pager    = paginate($total, $currentPage, ADMIN_ROWS_PER_PAGE);
$comments = db_all("
    SELECT c.*, a.title AS article_title, a.slug AS article_slug
    FROM   comments c
    JOIN   articles a ON a.id = c.article_id
    WHERE  $whereSQL
    ORDER  BY c.created_at DESC
    LIMIT ? OFFSET ?
", array_merge($params, [$pager['per_page'], $pager['offset']]));

$statusCounts = [
    'pending'  => db_count("SELECT COUNT(*) FROM comments WHERE status='pending'"),
    'approved' => db_count("SELECT COUNT(*) FROM comments WHERE status='approved'"),
    'spam'     => db_count("SELECT COUNT(*) FROM comments WHERE status='spam'"),
];

$adminTitle = 'Comments';
$ADMIN_TPL  = ROOT_PATH . '/admin/templates';
include $ADMIN_TPL . '/admin_header.php';
?>

<div class="admin-toolbar">
  <div class="status-tabs">
    <?php foreach (['pending'=>'Pending','approved'=>'Approved','spam'=>'Spam'] as $s => $label): ?>
    <a href="?status=<?= $s ?>"
       class="status-tab <?= $filterStatus===$s?'active':'' ?>">
      <?= $label ?>
      <?php if ($statusCounts[$s]): ?>
        <span class="nav-badge"><?= $statusCounts[$s] ?></span>
      <?php endif; ?>
    </a>
    <?php endforeach; ?>
  </div>
</div>

<div class="admin-card" style="padding:0;">
  <table class="admin-table">
    <thead>
      <tr><th>Author</th><th>Comment</th><th>On Article</th><th>Date</th><th>Actions</th></tr>
    </thead>
    <tbody>
      <?php if (empty($comments)): ?>
        <tr><td colspan="5" class="td-empty">No <?= h($filterStatus) ?> comments.</td></tr>
      <?php endif; ?>
      <?php foreach ($comments as $c): ?>
      <tr>
        <td>
          <strong><?= h($c['guest_name'] ?? 'User') ?></strong><br>
          <small><?= h($c['guest_email'] ?? '') ?></small>
        </td>
        <td><?= h(truncate($c['body'], 140)) ?></td>
        <td>
          <a href="<?= SITE_URL ?>/article.php?slug=<?= h($c['article_slug']) ?>#comments"
             target="_blank"><?= h(truncate($c['article_title'], 50)) ?></a>
        </td>
        <td><?= format_date($c['created_at'], 'd M Y H:i') ?></td>
        <td class="td-actions">
          <?php if ($c['status'] !== 'approved'): ?>
            <a href="?approve=<?= $c['id'] ?>&status=<?= h($filterStatus) ?>"
               class="tbl-btn tbl-btn--success">Approve</a>
          <?php endif; ?>
          <?php if ($c['status'] !== 'spam'): ?>
            <a href="?spam=<?= $c['id'] ?>&status=<?= h($filterStatus) ?>"
               class="tbl-btn tbl-btn--warning">Spam</a>
          <?php endif; ?>
          <a href="?delete=<?= $c['id'] ?>&status=<?= h($filterStatus) ?>"
             class="tbl-btn tbl-btn--danger"
             onclick="return confirm('Delete this comment?')">Delete</a>
        </td>
      </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>

<?php
$baseUrl = SITE_URL . '/admin/comments/index.php?status=' . urlencode($filterStatus);
include TEMPLATE_PATH . '/pagination.php';
include $ADMIN_TPL . '/admin_footer.php';
?>
