<?php
// ============================================================
//  admin/articles/index.php — Article list + bulk actions
// ============================================================
require_once dirname(__DIR__, 2) . '/app/config.php';
require_once ROOT_PATH . '/app/db.php';
require_once ROOT_PATH . '/app/functions.php';
require_editor();

// ── Quick status actions ──────────────────────────────────────
if (isset($_GET['delete']) && has_role('admin')) {
    $id = (int)$_GET['delete'];
    db_run("DELETE FROM articles WHERE id = ?", [$id]);
    redirect_with_message(SITE_URL . '/admin/articles/index.php', 'Article deleted.', 'success');
}
if (isset($_GET['publish'])) {
    $id = (int)$_GET['publish'];
    db_run("UPDATE articles SET status='published', published_at=COALESCE(published_at,NOW()) WHERE id=?", [$id]);
    redirect_with_message(SITE_URL . '/admin/articles/index.php', 'Article published.', 'success');
}
if (isset($_GET['draft'])) {
    $id = (int)$_GET['draft'];
    db_run("UPDATE articles SET status='draft' WHERE id=?", [$id]);
    redirect_with_message(SITE_URL . '/admin/articles/index.php', 'Article moved to draft.', 'success');
}

// ── Filters ───────────────────────────────────────────────────
$filterStatus = $_GET['status']   ?? '';
$filterCat    = (int)($_GET['cat'] ?? 0);
$search       = trim($_GET['q']   ?? '');
$currentPage  = max(1, (int)($_GET['page'] ?? 1));

$where  = ['1=1'];
$params = [];
if ($filterStatus) { $where[] = 'a.status = ?';      $params[] = $filterStatus; }
if ($filterCat)    { $where[] = 'a.category_id = ?'; $params[] = $filterCat; }
if ($search)       { $where[] = 'a.title LIKE ?';    $params[] = '%'.$search.'%'; }
$whereSQL = implode(' AND ', $where);

$total  = db_count("SELECT COUNT(*) FROM articles a WHERE $whereSQL", $params);
$pager  = paginate($total, $currentPage, ADMIN_ROWS_PER_PAGE);

$articles = db_all("
    SELECT a.id, a.title, a.slug, a.status, a.featured, a.views,
           a.read_time, a.published_at, a.created_at,
           u.name AS author_name,
           c.name AS category_name
    FROM   articles a
    JOIN   users u      ON u.id = a.author_id
    LEFT JOIN categories c ON c.id = a.category_id
    WHERE  $whereSQL
    ORDER  BY a.created_at DESC
    LIMIT  ? OFFSET ?
", array_merge($params, [$pager['per_page'], $pager['offset']]));

$allCats = db_all("SELECT id, name FROM categories WHERE type='article' ORDER BY sort_order");

$adminTitle = 'Articles';
$ADMIN_TPL  = ROOT_PATH . '/admin/templates';
include $ADMIN_TPL . '/admin_header.php';
?>

<div class="admin-toolbar">
  <!-- Filters -->
  <form class="toolbar-filters" method="GET">
    <input type="search" name="q" value="<?= h($search) ?>" placeholder="Search title…" class="admin-search">
    <select name="status" class="admin-select" onchange="this.form.submit()">
      <option value="">All statuses</option>
      <option value="published" <?= $filterStatus==='published'?'selected':'' ?>>Published</option>
      <option value="draft"     <?= $filterStatus==='draft'    ?'selected':'' ?>>Draft</option>
    </select>
    <select name="cat" class="admin-select" onchange="this.form.submit()">
      <option value="">All categories</option>
      <?php foreach ($allCats as $c): ?>
      <option value="<?= $c['id'] ?>" <?= $filterCat===$c['id']?'selected':'' ?>><?= h($c['name']) ?></option>
      <?php endforeach; ?>
    </select>
    <button type="submit" class="admin-btn">Filter</button>
    <a href="<?= SITE_URL ?>/admin/articles/index.php" class="admin-btn admin-btn--ghost">Clear</a>
  </form>
  <a href="<?= SITE_URL ?>/admin/articles/create.php" class="admin-btn admin-btn--primary">+ New Article</a>
</div>

<div class="admin-card" style="padding:0;">
  <table class="admin-table">
    <thead>
      <tr>
        <th>Title</th>
        <th>Category</th>
        <th>Author</th>
        <th>Status</th>
        <th>Views</th>
        <th>Date</th>
        <th>Actions</th>
      </tr>
    </thead>
    <tbody>
      <?php if (empty($articles)): ?>
      <tr><td colspan="7" class="td-empty">No articles found.</td></tr>
      <?php endif; ?>

      <?php foreach ($articles as $a): ?>
      <tr>
        <td class="td-title">
          <?php if ($a['featured']): ?><span class="featured-star" title="Featured">★</span><?php endif; ?>
          <a href="<?= SITE_URL ?>/admin/articles/edit.php?id=<?= $a['id'] ?>"><?= h($a['title']) ?></a>
        </td>
        <td><?= h($a['category_name'] ?? '—') ?></td>
        <td><?= h($a['author_name']) ?></td>
        <td><span class="status-badge status-<?= $a['status'] ?>"><?= ucfirst($a['status']) ?></span></td>
        <td><?= number_format($a['views']) ?></td>
        <td><?= format_date($a['created_at'], 'd M Y') ?></td>
        <td class="td-actions">
          <a href="<?= SITE_URL ?>/admin/articles/edit.php?id=<?= $a['id'] ?>" class="tbl-btn">Edit</a>
          <a href="<?= SITE_URL ?>/article.php?slug=<?= h($a['slug']) ?>" target="_blank" class="tbl-btn">View</a>
          <?php if ($a['status'] === 'draft'): ?>
          <a href="?publish=<?= $a['id'] ?>" class="tbl-btn tbl-btn--success">Publish</a>
          <?php else: ?>
          <a href="?draft=<?= $a['id'] ?>"   class="tbl-btn tbl-btn--warning">Unpublish</a>
          <?php endif; ?>
          <?php if (has_role('admin')): ?>
          <a href="?delete=<?= $a['id'] ?>" class="tbl-btn tbl-btn--danger"
             onclick="return confirm('Delete this article? This cannot be undone.')">Delete</a>
          <?php endif; ?>
        </td>
      </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>

<?php
$baseUrl = SITE_URL . '/admin/articles/index.php?'
         . http_build_query(array_filter(['status'=>$filterStatus,'cat'=>$filterCat,'q'=>$search]));
include TEMPLATE_PATH . '/pagination.php';
?>

<?php include $ADMIN_TPL . '/admin_footer.php'; ?>
